$(document).ready(function () {

  if ($('.main-nav ul li a[rel="container"]').length > 0) {
    $('.main-nav ul li a[rel="container"]').parent().children('ul').hide().removeClass('has-drop').addClass('mega');
    var tot = $('ul.mega').children('li');
    var divide = Math.ceil(tot.length / 4);
    $('.main-nav ul li a[rel="container"]').parent().append('<ul class="drop megacontain"></ul>');
    splitSubmenu(divide, 'mega');
    $('.mega').show().appendTo('.megacontain');
    $('#faqcta').appendTo('.megacontain').show();
  }

  if ($('.main-nav ul li a[rel="containertwo"]').length > 0) {
    $('.main-nav ul li a[rel="containertwo"]').parent().children('ul').hide().removeClass('has-drop').addClass('megatwo');
    var tot = $('ul.megatwo').children('li');
    var divide = Math.ceil(tot.length / 4);
    $('.main-nav ul li a[rel="containertwo"]').parent().append('<ul class="drop megacontaintwo"></ul>');
    splitSubmenu(divide, 'megatwo');
    $('.megatwo').show().appendTo('.megacontaintwo');
    $('#faqcta').appendTo('.megacontaintwo').show();
  }

  function splitSubmenu(maxNumItems, target) {
    $('.' + target).each(function () {

      // get all child li tags
      var list$ = $(this).children("li");
      var num, nextAfter$, after$ = $(this);

      // as long as the current list it too long, loop
      while (list$.length > maxNumItems) {
        // decide how many to remove this iteration
        num = Math.min(maxNumItems, list$.length - maxNumItems);
        // create new UL tag, append num items to it
        // and insert it into the DOM
        nextAfter$ = $('<ul class="' + target + '">')
          .append(list$.slice(maxNumItems, maxNumItems + num))
          .insertAfter(after$);
        // update insertion point for next loop iteration
        after$ = nextAfter$;
        // remove the items we just took out from the current jQuery object
        list$ = list$.filter(function (index) {
          return (index < maxNumItems || index >= 2 * maxNumItems);
        });
      }
    });
  }

  $("a[rel='lightbox']").magnificPopup({
    type: "image",
    mainClass: "mfp-fade",
    gallery: {
      enabled: true
    }
  });
  $('#editable table').each(function () {
    table2div(this);
  });
  //$('nav.main-nav').clone().appendTo('.mobile-nav-include');
  // $('.mobile-nav-include h1').remove();
  // $('.mobile-nav-include .search-form').prependTo('.nav-tools');
  //$('.mobile-nav-include > nav > ul > .last').remove();
  $('.mobile-nav-include .has-dropdown').prepend('<div class="open-icon"></div>');

  function initMobileNav(e, level) {
    if (e.hasClass('active')) {
      if (!e.hasClass('has-dropdown')) {
        return level;
      }
      level += 1;
      var ul = e.parent();
      e.siblings().each(function () {
        $(this).children('div').hide();
      });
      ul.siblings('div').each(function () {
        $(this).hide();
      });
      e.children('div').removeClass('open-icon');
      e.children('div').addClass('close-icon');
      e.addClass('expanded');
      ul.addClass('hidden');
      e.css('left', '108%');
      navul.css('left', '-' + ((level - 1) * 108) + '%');
      e.children('ul').each(function () {
        $(this).children('li').each(function () {
          level = initMobileNav($(this), level);
        });
      });
    }
    return level;
  }

  //-------* Inside Page Sidebar Nav *------//
  $('.open-icon').click(function () {
    //$(this).toggleClass('close-sub');
    if ($(this).hasClass('close-sub')) {
      $(this).removeClass('close-sub');
    } else {
      $(this).addClass('close-sub');
    }
    $(this).parent().children('ul').slideToggle(500);
    return false;
  });

  $(".open-icon").hover(
    function () {
      $(this).parent().children('a').addClass("hover");
    },
    function () {
      $(this).parent().children('a').removeClass("hover");
    }
  );

  if ($('.sidebar li.active').length > 0) {
    $('.sidebar li.active').each(function () {
      $("div:first", this).addClass('close-sub');
      $("div:first", this).children('open-icon').addClass('close-sub');
    });
  }

  // ------* Mobile Nav Menu Button *-------//
  $('.open-btn-top-center').on('click', function () {
    var icon_close = icon_open = null;
    icon_close = "<i class='fa fa-close'></i><span>Close</span>";
    icon_open = "<i class='fa fa-bars'></i><span>Menu</span>";
    if ($(this).hasClass('clicked')) {
      $(this).text(' ').append(icon_open).removeClass('clicked');
    } else {
      $(this).text(' ').append(icon_close).addClass('clicked');
    }
    $('.mobile-nav-wrapper').fadeToggle(200);
  });

  var navul = $('.mobile-nav-include .main-nav-mob > ul')

  var level = 1;
  navul.children('li').each(function () {
    level = initMobileNav($(this), level);
    console.log('init ' + level)
  });

  // ------* Mobile Nav Sliding Function *-------//
  $('.mobile-nav-include li.has-dropdown > div').on('click', function () {
    var li = $(this).parent();
    var ul = li.parent();
    if (li.hasClass('expanded')) {
      //CLOSE
      li.siblings().each(function () {
        $(this).children('div').show();
      });
      ul.siblings('div').each(function () {
        $(this).show();
      });
      $(this).removeClass('close-icon');
      $(this).addClass('open-icon');
      li.removeClass('expanded');
      ul.removeClass('hidden');
      level -= 1;
      li.css('left', 0);
      //ul.css('left', ((level-2)*108) + '%');
      navul.css('left', '-' + ((level - 1) * 108) + '%');
    } else {
      //OPEN
      li.siblings().each(function () {
        $(this).children('div').hide();
      });
      ul.siblings('div').each(function () {
        $(this).hide();
      });
      $(this).removeClass('open-icon');
      $(this).addClass('close-icon');
      li.addClass('expanded');
      ul.addClass('hidden');
      level += 1;
      li.css('left', '108%');
      //ul.css('left', ('-'+(level-2)*108) + '%');
      navul.css('left', '-' + ((level - 1) * 108) + '%');
    }
    //console.log('click ' + level);
  });

  //Check-In External Open
  $('.open-check-in').click(function (e) {
    e.preventDefault();
    $('#qliqsoft-btn-open-icon').trigger('click');
    $('#qliqsoft-container-teaser').hide();
  });
  setTimeout(function(){ $('#qliqsoft-container-teaser').fadeOut() }, 8000);
  $('.sc-header--right-button').click(function (e) {
    $('#qliqsoft-container-teaser').delay(1000).fadeOut();
  });
});